/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.replace.RegexPatternReplacer;
import com.aptana.core.util.replace.SimpleTextPatternReplacer;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceViewerConfiguration;
import com.aptana.editor.js.Messages;
import com.aptana.editor.js.actions.OpenDeclarationAction;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.editor.js.internal.JSModelUtil;
import com.aptana.editor.js.internal.text.JSFoldingComputer;
import com.aptana.editor.js.outline.JSOutlineContentProvider;
import com.aptana.editor.js.outline.JSOutlineLabelProvider;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.SinceElement;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSSourceEditor
extends AbstractThemeableEditor {
    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(JSSourceEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JSSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(JSPlugin.getDefault().getJSDocumentProvider());
    }

    public JSSourceViewerConfiguration getJSSourceViewerConfiguration() {
        return (JSSourceViewerConfiguration)super.getSourceViewerConfiguration();
    }

    protected void createActions() {
        super.createActions();
        OpenDeclarationAction action = new OpenDeclarationAction(Messages.getResourceBundle(), (ITextEditor)this);
        action.setActionDefinitionId("com.aptana.editor.js.openDeclaration");
        this.setAction("com.aptana.editor.js.openDeclaration", (IAction)action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("com.aptana.editor.js.openDeclaration");
        if (action != null) {
            menu.appendToGroup("group.open", action);
        }
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{JSPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new JSOutlineContentProvider();
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new JSOutlineLabelProvider();
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new JSFoldingComputer(this, document);
    }

    public String getContentType() {
        return "com.aptana.contenttype.js";
    }

    public Object getAdapter(Class adapter) {
        if (IContextProvider.class == adapter) {
            return new JSContextProvider(this);
        }
        return super.getAdapter(adapter);
    }

    public void refreshOutline(IParseRootNode ast) {
        this.outlineAutoExpanded = true;
        super.refreshOutline(ast);
    }

    private static final class JSContextProvider
    implements IContextProvider {
        private final JSSourceEditor editorPart;

        private JSContextProvider(JSSourceEditor editorPart) {
            this.editorPart = editorPart;
        }

        public String getSearchExpression(Object target) {
            return null;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            if (target instanceof IParseNode) {
                return new JSHelpContext(this.editorPart, (IParseNode)target);
            }
            ISelection selection = this.editorPart.getSelectionProvider().getSelection();
            if (selection.isEmpty()) {
                return null;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            return new JSHelpContext(this.editorPart, this.editorPart.getASTNodeAt(offset, this.editorPart.getAST()));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class JSHelpContext
        implements IContext2 {
            private static SimpleTextPatternReplacer TAG_MAPPER = new SimpleTextPatternReplacer();
            private static RegexPatternReplacer CODE_CLEANER;
            private AbstractThemeableEditor editor;
            private final IParseNode node;
            private Collection<PropertyElement> fProperties;

            static {
                TAG_MAPPER.addPattern("<h2>", "<b>");
                TAG_MAPPER.addPattern("</h2>", "</b>");
                TAG_MAPPER.addPattern("<h3>", "<b>");
                TAG_MAPPER.addPattern("</h3>", "</b>");
                TAG_MAPPER.addPattern("<pre>", "<code>");
                TAG_MAPPER.addPattern("</pre>", "</code>");
                TAG_MAPPER.addPattern("<p>", "<br><br>");
                TAG_MAPPER.addPattern("</p>", "<br><br>");
                TAG_MAPPER.addPattern("<hr>");
                for (String tag : CollectionsUtil.newList((Object[])new String[]{"warning", "tip", "glossary", "method", "varname", "specification"})) {
                    TAG_MAPPER.addPattern(StringUtil.concat((String[])new String[]{"<", tag, ">"}));
                    TAG_MAPPER.addPattern(StringUtil.concat((String[])new String[]{"</", tag, ">"}));
                }
                CODE_CLEANER = new RegexPatternReplacer();
                CODE_CLEANER.addPattern("<code>[^<]+</code>", (IMap)new IMap<String, String>(){

                    public String map(String item) {
                        return StringUtil.join((String)"</code><br><code>", (String[])StringUtil.LINE_SPLITTER.split(item));
                    }
                });
            }

            private JSHelpContext(AbstractThemeableEditor editor, IParseNode node) {
                this.editor = editor;
                this.node = node;
            }

            public IHelpResource[] getRelatedTopics() {
                Collection<PropertyElement> properties = this.getActiveProperty();
                if (!CollectionsUtil.isEmpty(properties)) {
                    HashSet<JSDOMHelpResource> refs = new HashSet<JSDOMHelpResource>();
                    Iterator<PropertyElement> iterator = properties.iterator();
                    if (iterator.hasNext()) {
                        PropertyElement pe = iterator.next();
                        for (SinceElement se : pe.getSinceList()) {
                            String version = se.getVersion();
                            if ("DOM 0".equals(version)) {
                                refs.add(new JSDOMHelpResource(0));
                                continue;
                            }
                            if ("HTML DOM Level 2".equals(version)) {
                                refs.add(new JSDOMHelpResource(2));
                                continue;
                            }
                            if ("HTML DOM Level 3".equals(version)) {
                                refs.add(new JSDOMHelpResource(3));
                                continue;
                            }
                            if (!"DOM5 HTML".equals(version)) continue;
                            refs.add(new JSDOMHelpResource(5));
                        }
                        return refs.toArray(new IHelpResource[refs.size()]);
                    }
                }
                return null;
            }

            public String getText() {
                Collection<PropertyElement> properties = this.getActiveProperty();
                if (!CollectionsUtil.isEmpty(properties)) {
                    return this.stripUnusedTags(JSModelFormatter.DYNAMIC_HELP.getDocumentation(properties));
                }
                return null;
            }

            private synchronized Collection<PropertyElement> getActiveProperty() {
                if (this.node == null) {
                    return Collections.emptyList();
                }
                if (this.fProperties == null) {
                    this.fProperties = JSModelUtil.getProperties(this.editor, this.node);
                }
                return this.fProperties;
            }

            private String stripUnusedTags(String text) {
                if (text == null) {
                    return null;
                }
                return CODE_CLEANER.searchAndReplace(TAG_MAPPER.searchAndReplace(text));
            }

            public String getTitle() {
                if (this.node == null) {
                    return null;
                }
                INameNode nameNode = this.node.getNameNode();
                if (nameNode == null) {
                    return null;
                }
                return nameNode.getName();
            }

            public String getStyledText() {
                return null;
            }

            public String getCategory(IHelpResource topic) {
                return null;
            }
        }
    }

    private static final class JSDOMHelpResource
    implements IHelpResource {
        private int domNumber;

        JSDOMHelpResource(int number) {
            this.domNumber = number;
        }

        public String getLabel() {
            return MessageFormat.format("DOM {0}", this.domNumber);
        }

        public String getHref() {
            return MessageFormat.format("http://aptana.com/reference/html/api/HTMLDOM{0}.index.html", this.domNumber);
        }

        public boolean equals(Object obj) {
            if (obj instanceof JSDOMHelpResource) {
                JSDOMHelpResource other = (JSDOMHelpResource)obj;
                return other.domNumber == this.domNumber;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.domNumber;
        }
    }
}

